/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package chapter6;


/**
 * @author Matthew Gregory website: www.matthewgregory-author.com.au
 *
 */
public class Person {

    public String type;
    public String firstName;
    public String lastName;
    public int age;
    public double salary;
    public String department;

    //Constructor
    public Person(String type, String firstName, String lastName, int age) {

        //Check to make sure type is either employee or customer
        //Using a switch statement.
        switch (type) {
            case "Employee":
            case "Customer":
                System.out.println("This has been certified to be of the right type.");
                break;
            default:
                System.out.println("Warning you have specified a type of " + type);
                System.out.println("Type should be either Employee or Customer");
        }

        this.type = type;
        setNames(firstName, lastName);
        this.age = age;
    }

    //No Arguement constructor
    public Person() {
    }

    public String getFullName() {
        return firstName + " " + lastName;
    }

    public void printDetails() {
        System.out.println("Full Name: " + getFullName());
        System.out.println("Type: " + type);
        System.out.println("Age: " + age);
    }

    public void setNames(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
    }
    
    public String toString(){
        return getFullName();
    }

}
